/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.WorldEventListener;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.block.BlockFireBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.info.ItemConfig;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.network.MessagePlayerLeftClick;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class GameEventListener {
    WorldEventListener worldEventListener = new WorldEventListener(this);

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        ObjectManager.registerBlocks(event);
        ItemManager.getInstance().registerBlockOres();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        ObjectManager.registerItems(event);
        ItemManager.getInstance().registerItemOres();
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        ObjectManager.registerPotions(event);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        ObjectManager.registerSpecialEntities(event);
    }

    @SubscribeEvent
    public void onWorldLoading(WorldEvent.Load event) {
        if (event.getWorld() == null) {
            return;
        }
        ExtendedWorld.getForWorld(event.getWorld());
        event.getWorld().func_72954_a((IWorldEventListener)this.worldEventListener);
    }

    @SubscribeEvent
    public void onWorldUnloading(WorldEvent.Unload event) {
        ExtendedWorld.remove(event.getWorld());
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(new ResourceLocation("lycanitesmobs", "IExtendedEntity"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                private final ExtendedEntity instance = (ExtendedEntity)LycanitesMobs.EXTENDED_ENTITY.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == LycanitesMobs.EXTENDED_ENTITY;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LycanitesMobs.EXTENDED_ENTITY ? LycanitesMobs.EXTENDED_ENTITY.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LycanitesMobs.EXTENDED_ENTITY.getStorage().writeNBT(LycanitesMobs.EXTENDED_ENTITY, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    LycanitesMobs.EXTENDED_ENTITY.getStorage().readNBT(LycanitesMobs.EXTENDED_ENTITY, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("lycanitesmobs", "IExtendedPlayer"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                private final ExtendedPlayer instance = (ExtendedPlayer)LycanitesMobs.EXTENDED_PLAYER.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == LycanitesMobs.EXTENDED_PLAYER;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LycanitesMobs.EXTENDED_PLAYER ? LycanitesMobs.EXTENDED_PLAYER.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LycanitesMobs.EXTENDED_PLAYER.getStorage().writeNBT(LycanitesMobs.EXTENDED_PLAYER, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    LycanitesMobs.EXTENDED_PLAYER.getStorage().readNBT(LycanitesMobs.EXTENDED_PLAYER, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        ExtendedPlayer extendedPlayerOld = ExtendedPlayer.getForPlayer(event.getOriginal());
        ExtendedPlayer extendedPlayerNew = ExtendedPlayer.getForPlayer(event.getEntityPlayer());
        NBTTagCompound nbt = new NBTTagCompound();
        extendedPlayerOld.writeNBT(nbt);
        extendedPlayerNew.readNBT(nbt);
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ExtendedPlayer.getForPlayer((EntityPlayer)event.player).needsFullSync = true;
    }

    @SubscribeEvent
    public void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        ExtendedPlayer.getForPlayer((EntityPlayer)event.player).needsFullSync = true;
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity() == null || event.getEntity().func_130014_f_() == null || event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLivingBase) && ExtendedEntity.FORCE_REMOVE_ENTITY_IDS != null && ExtendedEntity.FORCE_REMOVE_ENTITY_IDS.length > 0) {
            LycanitesMobs.logDebug("ForceRemoveEntity", "Forced entity removal, checking: " + event.getEntity().func_70005_c_());
            for (String forceRemoveID : ExtendedEntity.FORCE_REMOVE_ENTITY_IDS) {
                if (!forceRemoveID.equalsIgnoreCase(event.getEntity().func_70005_c_())) continue;
                event.getEntity().func_70106_y();
                break;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        EntityPlayer player;
        ExtendedPlayer extendedPlayer;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.onDeath();
        }
        if (entity instanceof EntityPlayer && (extendedPlayer = ExtendedPlayer.getForPlayer(player = (EntityPlayer)entity)) != null) {
            extendedPlayer.onDeath();
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        ExtendedPlayer playerExt;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.onUpdate();
        }
        if (entity instanceof EntityPlayer && (playerExt = ExtendedPlayer.getForPlayer(player = (EntityPlayer)entity)) != null) {
            playerExt.onUpdate();
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.func_184586_b(event.getHand());
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemEquipment) {
            MessagePlayerLeftClick message = new MessagePlayerLeftClick();
            LycanitesMobs.packetHandler.sendToServer(message);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || event.getSide().isClient()) {
            return;
        }
        ItemStack itemStack = player.func_184586_b(event.getHand());
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemEquipment) {
            ((ItemEquipment)item).onItemLeftClick(event.getWorld(), player, event.getHand());
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack;
        Item item;
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        if (player == null || entity == null) {
            return;
        }
        if (player.func_184586_b(event.getHand()) != null && (item = (itemStack = player.func_184586_b(event.getHand())).func_77973_b()) instanceof ItemBase && ((ItemBase)item).onItemRightClickOnEntity(player, entity, itemStack) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase targetEntity = event.getTarget();
        if (event.getEntityLiving() == null || targetEntity == null) {
            return;
        }
        if (!event.getEntityLiving().func_70644_a(MobEffects.field_76439_r) && targetEntity.func_82150_aj()) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            return;
        }
        if (event.getEntityLiving() instanceof EntityLiving && targetEntity instanceof BaseCreatureEntity && !((BaseCreatureEntity)targetEntity).canBeTargetedBy(event.getEntityLiving()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingHurtEvent event) {
        ExtendedEntity attackerExtendedEntity;
        EntityDamageSource entityDamageSource;
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource() == null || event.getEntityLiving() == null) {
            return;
        }
        EntityLivingBase damagedEntity = event.getEntityLiving();
        ExtendedEntity damagedEntityExt = ExtendedEntity.getForEntity(damagedEntity);
        if (event.getSource() instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)event.getSource()).func_76346_g() != null && entityDamageSource.func_76346_g() instanceof EntityLivingBase && (attackerExtendedEntity = ExtendedEntity.getForEntity((EntityLivingBase)entityDamageSource.func_76346_g())) != null) {
            attackerExtendedEntity.setLastAttackedEntity(damagedEntity);
        }
        if (damagedEntity.func_184187_bx() != null && damagedEntity.func_184187_bx() instanceof RideableCreatureEntity) {
            RideableCreatureEntity creatureRideable = (RideableCreatureEntity)event.getEntityLiving().func_184187_bx();
            if (creatureRideable.isBlocking()) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
            if ("inWall".equals(event.getSource().field_76373_n)) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
            if (!creatureRideable.isDamageTypeApplicable(event.getSource().field_76373_n, event.getSource(), event.getAmount())) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
        }
        if (damagedEntityExt != null && damagedEntityExt.isPickedUp() && "inWall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        World world = event.getEntityLiving().func_130014_f_();
        if (ItemConfig.seasonalItemDropChance > 0.0 && (Utilities.isHalloween() || Utilities.isYuletide() || Utilities.isNewYear())) {
            boolean noSeaonalDrop = false;
            if (event.getEntityLiving() instanceof BaseCreatureEntity && ((BaseCreatureEntity)event.getEntityLiving()).isMinion()) {
                noSeaonalDrop = true;
            }
            Item seasonalItem = null;
            if (Utilities.isHalloween()) {
                seasonalItem = ObjectManager.getItem("halloweentreat");
            }
            if (Utilities.isYuletide()) {
                seasonalItem = ObjectManager.getItem("wintergift");
                if (Utilities.isYuletidePeak() && world.field_73012_v.nextBoolean()) {
                    seasonalItem = ObjectManager.getItem("wintergiftlarge");
                }
            }
            if (seasonalItem != null && !noSeaonalDrop && (double)event.getEntityLiving().func_70681_au().nextFloat() < ItemConfig.seasonalItemDropChance) {
                ItemStack dropStack = new ItemStack(seasonalItem, 1);
                EntityItemCustom entityItem = new EntityItemCustom(world, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, dropStack);
                entityItem.func_174867_a(10);
                world.func_72838_d((Entity)entityItem);
            }
        }
    }

    @SubscribeEvent
    public void onMountEntity(EntityMountEvent event) {
        BaseCreatureEntity creatureEntity;
        if (event.isMounting() && event.getEntityBeingMounted() instanceof EntityBoat && event.getEntityBeingMounted() instanceof EntityMinecart && event.getEntityMounting() instanceof BaseCreatureEntity && ((creatureEntity = (BaseCreatureEntity)event.getEntityMounting()).isBoss() || creatureEntity.field_70130_N >= 2.0f || creatureEntity.field_70131_O >= 2.0f)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        World world = event.getWorld();
        RayTraceResult target = event.getTarget();
        if (target == null) {
            return;
        }
        BlockPos pos = target.func_178782_a();
        Block block = world.func_180495_p(pos).func_177230_c();
        Item bucket = ObjectManager.buckets.get(block);
        if (bucket != null && (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            world.func_175698_g(pos);
        }
        if (bucket == null) {
            return;
        }
        event.setFilledBucket(new ItemStack(bucket));
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState() == null || event.getWorld() == null || event.isCanceled() || event.getWorld().field_72995_K) {
            return;
        }
        if (event.getPlayer() != null && !event.getPlayer().func_184812_l_()) {
            ExtendedWorld extendedWorld = ExtendedWorld.getForWorld(event.getWorld());
            if (!(event.getState().func_177230_c() instanceof BlockFireBase) && extendedWorld.isBossNearby(new Vec3d((Vec3i)event.getPos()))) {
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
                event.getPlayer().func_146105_b((ITextComponent)new TextComponentString(LanguageManager.translate("boss.block.protection.break")), true);
                return;
            }
        }
        if (event.getPlayer() != null) {
            ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(event.getPlayer());
            if (extendedPlayer == null) {
                return;
            }
            extendedPlayer.setJustBrokenBlock(event.getState());
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        ExtendedWorld extendedWorld;
        if (event.getState() == null || event.getWorld() == null || event.isCanceled()) {
            return;
        }
        if (event.getPlayer() != null && !event.getPlayer().func_184812_l_() && (extendedWorld = ExtendedWorld.getForWorld(event.getWorld())).isBossNearby(new Vec3d((Vec3i)event.getPos()))) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            event.getPlayer().func_146105_b((ITextComponent)new TextComponentString(LanguageManager.translate("boss.block.protection.place")), true);
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (!LycanitesMobs.config.getBool("Extras", "Disable Sneak Dismount", true)) {
            return;
        }
        if (!(event.isDismounting() && event.getEntityMounting() instanceof EntityPlayer && event.getEntityBeingMounted() instanceof RideableCreatureEntity)) {
            return;
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer((EntityPlayer)event.getEntityMounting());
        if (extendedPlayer == null) {
            return;
        }
        event.setCanceled(event.getEntityMounting().func_70093_af() && !extendedPlayer.isControlActive(ExtendedPlayer.CONTROL_ID.MOUNT_DISMOUNT));
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity shooter = null;
        Entity target = event.getRayTraceResult().field_72308_g;
        if (!(target instanceof BaseCreatureEntity)) {
            return;
        }
        BaseCreatureEntity targetCreature = (BaseCreatureEntity)target;
        if (event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            shooter = arrow.field_70250_c;
        }
        if (event.getEntity() instanceof EntityThrowable) {
            EntityThrowable throwable = (EntityThrowable)event.getEntity();
            shooter = throwable.func_85052_h();
        }
        if (shooter != null && !targetCreature.isDamageEntityApplicable(shooter)) {
            event.setCanceled(true);
        }
    }
}

